﻿Imports System.Data.SqlClient

Public Class frmSales
    Dim gridCount, count As Integer
    Dim TotalAmt As Double
    Dim billId As String
    Dim salesDs, newSalesDs As New DataSet
    Dim salesDa, newSalesDa As SqlDataAdapter
    Dim itemCategoryId(500), itemCode(500), taxCaode(500), custoerCode(500) As String

    Private Sub frmSales_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        Try
            Db_Connection()
            LoadItemCategory()
            LoadTax()
            LoadCustomer()
            billId = getLastInserId("SALES_MASTER")
            txtBillNo.Text = billId
        Catch ex As Exception

        End Try

    End Sub
    Private Sub LoadItemCategory()
        Try

            'LOAD ITEM CATEGORY
            salesDs.Reset()
            sql = " SELECT CAT_CATEGORYID, CAT_CATEGORYNAME, CREATED_DATE FROM ITEM_CATEGORY WHERE IS_DELETE = 0  "
            salesDa = New SqlDataAdapter(sql, Mycn)
            salesDa.Fill(salesDs, DBNAME)
            Dim rowCount = salesDs.Tables(DBNAME).Rows.Count

            cmbCategoryName.Items.Clear()
            For i = 0 To rowCount - 1
                itemCategoryId(i) = salesDs.Tables(DBNAME).Rows(i).Item(0)
                cmbCategoryName.Items.Add(salesDs.Tables(DBNAME).Rows(i).Item(1))
            Next
        Catch ex As Exception
            MsgBox(ex.Message)
        End Try
    End Sub
    Private Sub LoadItemCode()
        Try

            'LOAD ITEM NAME
            salesDs.Reset()
            sql = " SELECT ITM_ITEMCODE, ITM_ITEMDESC, ITM_QTYTYPE FROM ITEMS WHERE ITM_CATID = '" & itemCategoryId(cmbCategoryName.SelectedIndex) & "' AND IS_DELETE = 0 "
            salesDa = New SqlDataAdapter(sql, Mycn)
            salesDa.Fill(salesDs, DBNAME)
            Dim rowCount = salesDs.Tables(DBNAME).Rows.Count
            cmbItemCode.Items.Clear()
            cmbItemName.Items.Clear()
            For i = 0 To rowCount - 1
                itemCode(i) = salesDs.Tables(DBNAME).Rows(i).Item(0)
                cmbItemCode.Items.Add(salesDs.Tables(DBNAME).Rows(i).Item(0))
                cmbItemName.Items.Add(salesDs.Tables(DBNAME).Rows(i).Item(1))
            Next
        Catch ex As Exception
            MsgBox(ex.Message)
        End Try
    End Sub

    Private Sub LoadItemDesc()
        Try
            salesDs.Reset()
            sql = "SELECT A.ITM_ITEMDESC, B.QTY_TYPE, A.ITM_MRP FROM ITEMS AS A LEFT JOIN QTYPE_MASTER AS B ON A.ITM_QTYTYPE = B.QTY_CODE WHERE A.ITM_ITEMCODE = '" & itemCode(cmbItemCode.SelectedIndex) & "' AND A.IS_DELETE =  0"
            salesDa = New SqlDataAdapter(sql, Mycn)
            salesDa.Fill(salesDs, DBNAME)
            Dim rowCount = salesDs.Tables(DBNAME).Rows.Count
            If rowCount > 0 Then
                cmbItemName.Text = salesDs.Tables(DBNAME).Rows(0).Item(0)
                txtQtyType.Text = salesDs.Tables(DBNAME).Rows(0).Item(1)
                txtMrpValue.Text = salesDs.Tables(DBNAME).Rows(0).Item(2)
            End If
        Catch ex As Exception
            MsgBox(ex.Message)
        End Try
    End Sub

    Private Sub cmbCategoryName_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmbCategoryName.SelectedIndexChanged
        LoadItemCode()

    End Sub

    Private Sub cmbItemCode_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmbItemCode.SelectedIndexChanged
        LoadItemDesc()
        txtTotalAmount.Text = (Val(txtStkQty.Text) * Val(txtMrpValue.Text))
    End Sub

    Private Sub cmbItemName_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmbItemName.SelectedIndexChanged
        LoadItemName()
        txtTotalAmount.Text = (Val(txtStkQty.Text) * Val(txtMrpValue.Text))
    End Sub
    Private Sub LoadItemName()
        Try
            salesDs.Reset()
            sql = "SELECT A.ITM_ITEMCODE, B.QTY_TYPE, A.ITM_MRP FROM ITEMS AS A LEFT JOIN QTYPE_MASTER AS B ON A.ITM_QTYTYPE = B.QTY_CODE WHERE A.ITM_ITEMCODE = '" & itemCode(cmbItemName.SelectedIndex) & "' AND A.IS_DELETE =  0"
            salesDa = New SqlDataAdapter(sql, Mycn)
            salesDa.Fill(salesDs, DBNAME)
            Dim rowCount = salesDs.Tables(DBNAME).Rows.Count
            If rowCount > 0 Then
                cmbItemCode.Text = salesDs.Tables(DBNAME).Rows(0).Item(0)
                txtQtyType.Text = salesDs.Tables(DBNAME).Rows(0).Item(1)
                txtMrpValue.Text = salesDs.Tables(DBNAME).Rows(0).Item(2)
            End If
        Catch ex As Exception
            MsgBox(ex.Message)
        End Try
    End Sub

    Private Sub btnCancel_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnCancel.Click
        Me.Close()
    End Sub

    Private Sub LoadTax()
        Try
            salesDs.Reset()
            sql = "SELECT ID, TAX_PERC FROM TAX_MASTER WHERE IS_DELETE = 0 "
            salesDa = New SqlDataAdapter(sql, Mycn)
            salesDa.Fill(salesDs, DBNAME)
            Dim rowCount = salesDs.Tables(DBNAME).Rows.Count
            For i = 0 To rowCount - 1
                taxCaode(i) = salesDs.Tables(DBNAME).Rows(i).Item(0)
                cmbTax.Items.Add(salesDs.Tables(DBNAME).Rows(i).Item(1))
            Next
        Catch ex As Exception
            MsgBox(ex.Message)
        End Try
    End Sub
    Private Sub LoadCustomer()
        Try
            salesDs.Reset()
            sql = "SELECT CUS_ID, CUS_NAME FROM CUSTOMER_MASTER WHERE IS_DELETE = 0 "
            salesDa = New SqlDataAdapter(sql, Mycn)
            salesDa.Fill(salesDs, DBNAME)
            Dim rowCount = salesDs.Tables(DBNAME).Rows.Count
            For i = 0 To rowCount - 1
                custoerCode(i) = salesDs.Tables(DBNAME).Rows(i).Item(0)
                cmbCustomer.Items.Add(salesDs.Tables(DBNAME).Rows(i).Item(1))
            Next
        Catch ex As Exception
            MsgBox(ex.Message)
        End Try
    End Sub

    Private Sub txtStkQty_TextChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles txtStkQty.TextChanged
        txtTotalAmount.Text = (Val(txtStkQty.Text) * Val(txtMrpValue.Text))
    End Sub

    Private Sub cmbTax_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmbTax.SelectedIndexChanged
        Try
            txtGross.Text = Val(txtTotalAmount.Text + (txtTotalAmount.Text * taxCaode(cmbTax.SelectedIndex) / 100))
        Catch ex As Exception
            MsgBox(ex.Message)
        End Try
    End Sub

    Private Sub btnAdd_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnAdd.Click
        bindGrindList()
        For i = 0 To dgvSales.RowCount - 2
            TotalAmt = Val(TotalAmt + dgvSales.Rows(i).Cells(9).Value)
            txtTotalGrossAmount.Text = TotalAmt
        Next
        TotalAmt = 0.0
    End Sub
    Sub bindGrindList()

        Try
            dgvSales.Rows.Add()
            dgvSales.Item(0, gridCount).Value = gridCount + 1
            dgvSales.Item(1, gridCount).Value = cmbCategoryName.Text
            dgvSales.Item(2, gridCount).Value = cmbItemCode.Text
            dgvSales.Item(3, gridCount).Value = cmbItemName.Text
            dgvSales.Item(4, gridCount).Value = txtQtyType.Text
            dgvSales.Item(5, gridCount).Value = txtStkQty.Text
            dgvSales.Item(6, gridCount).Value = txtMrpValue.Text
            dgvSales.Item(7, gridCount).Value = txtTotalAmount.Text
            dgvSales.Item(8, gridCount).Value = (cmbTax.Text + "%")
            dgvSales.Item(9, gridCount).Value = txtGross.Text
            dgvSales.Item(10, gridCount).Value = itemCategoryId(cmbCategoryName.SelectedIndex)
            dgvSales.Item(11, gridCount).Value = taxCaode(cmbTax.SelectedIndex)
            gridCount += 1

        Catch ex As Exception
            MsgBox(ex.Message)
        End Try

    End Sub

    Private Sub btnDelete_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnDelete.Click
        dgvSales.Rows.RemoveAt(dgvSales.CurrentRow.Index)
        gridCount -= 1
        For i = 0 To dgvSales.RowCount - 2
            TotalAmt = Val(TotalAmt + dgvSales.Rows(i).Cells(9).Value)
            txtTotalGrossAmount.Text = TotalAmt
        Next
        TotalAmt = 0.0
    End Sub

    Private Sub txtDiscount_TextChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles txtDiscount.TextChanged
        If Trim(txtDiscount.Text) <> "" Then
            If txtDiscount.Text <> 0 Then
                txtFinalAmount.Text = Val(txtTotalGrossAmount.Text) - (txtTotalGrossAmount.Text * (txtDiscount.Text / 100))
            Else
                txtFinalAmount.Text = txtTotalGrossAmount.Text
            End If
        Else
            txtFinalAmount.Text = txtTotalGrossAmount.Text
        End If
    End Sub

    Private Sub txtTotalGrossAmount_TextChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles txtTotalGrossAmount.TextChanged
        txtFinalAmount.Text = Val(txtTotalGrossAmount.Text) - Val(Val(txtTotalGrossAmount.Text) * Val(txtDiscount.Text) / 100)
    End Sub

    Sub updateSalesList()

        Try
            count += 1

            If count = 1 Then

                newSalesDs.Reset()
                sql = "SELECT SLS_CUSTOMER_ID, SLS_SELL_DATE, SLS_BILL_NO, SLS_AMOUNT, SLS_DISCOUNT, SLS_PAIED, CREATED_DATE FROM SALES_MASTER"
                newSalesDa = New SqlDataAdapter(sql, Mycn)
                newSalesDa.Fill(newSalesDs, DBNAME)
                Dim cb As New SqlCommandBuilder(newSalesDa)
                Dim dsNewRow As DataRow
                dsNewRow = newSalesDs.Tables(DBNAME).NewRow()
                dsNewRow.Item("SLS_CUSTOMER_ID") = txtCusId.Text
                dsNewRow.Item("SLS_SELL_DATE") = dtpDate.Value.ToString("MM/dd/yyyy")
                dsNewRow.Item("SLS_BILL_NO") = billId
                dsNewRow.Item("SLS_AMOUNT") = txtTotalGrossAmount.Text
                dsNewRow.Item("SLS_DISCOUNT") = txtDiscount.Text
                dsNewRow.Item("SLS_PAIED") = txtPaiedAmt.Text
                dsNewRow.Item("CREATED_DATE") = Now.ToString("MM/dd/yyyy")
                newSalesDs.Tables(DBNAME).Rows.Add(dsNewRow)
                newSalesDa.Update(newSalesDs, DBNAME)
            Else

                sql = "UPDATE SALES_MASTER SET SLS_AMOUNT=" & Val(txtTotalGrossAmount.Text) & ", SLS_DISCOUNT=" & Val(txtDiscount.Text) & " WHERE SLS_BILL_NO='" & billId & "'"
                newSalesDa = New SqlDataAdapter(sql, Mycn)
                newSalesDa.Fill(newSalesDs, DBNAME)

            End If

        Catch ex As Exception

            MsgBox(ex.Message)

        End Try
    End Sub

    Private Sub btnComplete_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnComplete.Click
        Try
            If txtDiscount.Text <> "" And txtFinalAmount.Text <> "" And txtTotalGrossAmount.Text <> "" And txtPaiedAmt.Text <> "" Then
                If dgvSales.RowCount <> 1 Then
                    updateSalesList()
                    For j = 0 To dgvSales.RowCount - 2

                        sql = "SELECT SLI_BILL_NO, SLI_ITEM_CODE, SLI_CATEGORY, SLI_ITEM_QTY, SLI_MRP, SLI_TOTAL, SLI_TAX, SLI_GROSS, CREATED_DATE FROM SALES_ITEMS WHERE IS_DELETE=0"
                        newSalesDa = New SqlDataAdapter(sql, Mycn)
                        newSalesDa.Fill(newSalesDs, DBNAME)
                        Dim cb As New SqlCommandBuilder(newSalesDa)
                        Dim dsNewRow As DataRow
                        dsNewRow = newSalesDs.Tables(DBNAME).NewRow()
                        dsNewRow.Item("SLI_BILL_NO") = billId
                        dsNewRow.Item("SLI_ITEM_CODE") = dgvSales.Rows(j).Cells(2).Value
                        dsNewRow.Item("SLI_CATEGORY") = dgvSales.Rows(j).Cells(10).Value
                        dsNewRow.Item("SLI_ITEM_QTY") = dgvSales.Rows(j).Cells(5).Value
                        dsNewRow.Item("SLI_MRP") = dgvSales.Rows(j).Cells(6).Value
                        dsNewRow.Item("SLI_TOTAL") = dgvSales.Rows(j).Cells(7).Value
                        dsNewRow.Item("SLI_TAX") = dgvSales.Rows(j).Cells(11).Value
                        dsNewRow.Item("SLI_GROSS") = dgvSales.Rows(j).Cells(9).Value
                        dsNewRow.Item("CREATED_DATE") = Now.ToString("MM/dd/yyyy")
                        newSalesDs.Tables(DBNAME).Rows.Add(dsNewRow)
                        newSalesDa.Update(newSalesDs, DBNAME)

                        newSalesDs.Reset()
                        sql = "UPDATE ITEM_STOCK SET STK_ITEMQTY=STK_ITEMQTY-" & dgvSales.Rows(j).Cells(5).Value & " WHERE STK_ITEMCODE = '" & dgvSales.Rows(j).Cells(2).Value & "'"
                        newSalesDa = New SqlDataAdapter(sql, Mycn)
                        newSalesDa.Fill(newSalesDs, DBNAME)
                    Next
                    MsgBox("New item added.")

                End If
            End If

        Catch ex As Exception

            MsgBox(ex.Message)

        End Try
    End Sub


    Private Sub cmbCustomer_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmbCustomer.SelectedIndexChanged
        LoadCustomerCode()
    End Sub

    Private Sub LoadCustomerCode()
        Try
            salesDs.Reset()
            sql = "SELECT CUS_ID, CUS_NAME FROM CUSTOMER_MASTER WHERE CUS_ID = ' " & custoerCode(cmbCustomer.SelectedIndex) & " ' and IS_DELETE = 0 "
            salesDa = New SqlDataAdapter(sql, Mycn)
            salesDa.Fill(salesDs, DBNAME)
            Dim rowCount = salesDs.Tables(DBNAME).Rows.Count
            For i = 0 To rowCount - 1
                txtCusId.Text = salesDs.Tables(DBNAME).Rows(i).Item(0)
            Next
        Catch ex As Exception
            MsgBox(ex.Message)
        End Try
    End Sub

    Private Sub btnPrint_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnPrint.Click

    End Sub
End Class